/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PIEnvInfoDataBean;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.PIHscUtil;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;

public class PIHardwareInfoList {
    private static final int NUM_VALID_PARMS = 4;
    private String m_frame;
    private String m_resourceType;
    private String m_format;
    private boolean m_header;
    private HashMap m_validParms = new HashMap(9, 0.5f);
    private PIHSCClientObjectFactory m_factory = null;
    private PIHSCFrameClient m_FrameClient = null;
    private String m_theHostName = null;
    private String m_delimiter = ",";
    private PrintStream m_outStream;
    private boolean m_writeStatus;

    private PIHardwareInfoList(PIHSCFrameClient pIHSCFrameClient, PrintStream printStream, boolean bl) {
        this.m_FrameClient = pIHSCFrameClient;
        this.m_outStream = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-e", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
    }

    private void doFrameList() throws PIHscClientException {
        if (this.m_frame != null) {
            this.doSingleFrameList(this.m_FrameClient);
        } else {
            try {
                Enumeration enumeration = null;
                enumeration = PIHscUtil.getCIMEnumInstances(this.m_theHostName, new CIMObjectPath("IBMHSC_Frame", "root/ibmhscS1_0"), true, false);
                if (enumeration == null || !enumeration.hasMoreElements()) {
                    this.doSingleFrameList(null);
                } else {
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        Object var2_3 = null;
                        CIMInstance cIMInstance = null;
                        cIMInstance = (CIMInstance)enumeration.nextElement();
                        String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
                        PIHSCFrameClient pIHSCFrameClient = this.m_factory.createFrameClient(string, false);
                        if (pIHSCFrameClient == null) continue;
                        this.doSingleFrameList(pIHSCFrameClient);
                    }
                }
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
            }
        }
    }

    private void doSingleFrameList(PIHSCFrameClient pIHSCFrameClient) throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"input_voltage_phases_a_b", "input_voltage_phases_b_c", "input_voltage_phases_c_a", "input_current_phase_a", "input_current_phase_b", "input_current_phase_c"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector<PIEnvInfoDataBean> vector = new Vector<PIEnvInfoDataBean>();
        if (pIHSCFrameClient != null) {
            PIEnvInfoDataBean pIEnvInfoDataBean = pIHSCFrameClient.getEnvironmentalInfo();
            vector.addElement(pIEnvInfoDataBean);
        }
        PICmdOutputUtils.printResults(this.m_outStream, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        this.m_writeStatus = false;
    }

    private void performCommand() throws PIHscClientException {
        this.checkParameters();
        try {
            this.m_theHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_factory = PIHSCClientObjectFactory.getInstance(this.m_theHostName, null);
        this.doFrameList();
    }

    private void checkParameters() throws PIHscClientException {
        if (this.m_resourceType == null || !"frame".equals(this.m_resourceType)) {
            String[] stringArray = new String[]{"-r"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_header && this.m_format == null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_frame = (String)hashMap.get("-e");
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_format = (String)hashMap.get("-F");
        String string = (String)hashMap.get("--header");
        this.m_header = string != null;
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSHWINFO_HELP"));
    }

    public static int callCommandFromRouter(PIHSCFrameClient pIHSCFrameClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIHardwareInfoList pIHardwareInfoList = new PIHardwareInfoList(pIHSCFrameClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIHardwareInfoList.m_validParms);
            pIHardwareInfoList.mapParameters(hashMap);
            pIHardwareInfoList.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

